	<?php
// Start a session
session_start();

// Database connection
include "../connection.php"; 

// Check if the user is logged in
if (!isset($_SESSION['userid'])) {
    header("Location: ../login.php");
    exit();
}

// Retrieve user data and balance
$userid = $_SESSION['userid'];
$sql = "SELECT s.username, s.number, COALESCE(b.amount, 0) AS amount FROM student s
        LEFT JOIN balance b ON s.userid = b.userid
        WHERE s.userid = ?";
$stmt = $con->prepare($sql);

if (!$stmt) {
    die("Query preparation failed: " . $con->error);
}

$stmt->bind_param("s", $userid);
$stmt->execute();
$result = $stmt->get_result();

// Fetch user data and balance
if ($row = $result->fetch_assoc()) {
    $username = htmlspecialchars($row['username']); // Sanitize output
    $number = htmlspecialchars($row['number']);     // Sanitize output
    $amount = htmlspecialchars($row['amount']);     // Sanitize output
} else {
    // Since we are using LEFT JOIN, this block should not execute anymore.
    echo "User data not found.";
    exit();
}

// Close connection
$stmt->close();
$con->close();
?>


	
	<?php include 'header-link.php' ?>

    <main>
		<?php include 'top-bar.php' ?>
        <section>   
			<div class="container my-1">
				<div class="row justify-content-center">
					<div class="col-md-6">
						<div class="card custom-card">
							<div class="card-body">
								<h5 class="card-title text-center d-block my-3">  <u> আপনার প্রোফাইল </u> </h5>
									
									<div class="row">
										<div class="col-8">
											<h5 class="mb-3"> <i class="fa-duotone fa-solid fa-user mx-2" style="color:#FF5F00;"></i>  <?php echo htmlspecialchars($username); ?> </h5>  <hr style="width:75%;">   
											<h6> <i class="fa-duotone fa-solid fa-phone mx-2" style="color:#FF5F00;"></i>  <?php echo htmlspecialchars($number); ?> </h6>   <hr style="width:75%;">                
											<h6> <i class="fa-solid fa-bangladeshi-taka-sign mx-2" style="color:#FF5F00;"></i>  <?php echo htmlspecialchars( number_format($amount)); ?> </h6>   <hr style="width:75%;">                
                                    
										</div>
										
										<div class="col-4">
											<img src="img/user1.png" width="120px" height="120px" style="margin:;" >
										</div>
										
										<div class="col-4 my-3 text-center">
											<a href="name-change.php" class="nav-link info-tab-item" title="নাম পরিবর্তন"><i class="profile-icon fa-duotone fa-solid fa-id-card fa-2x"></i> <br>  নাম পরিবর্তন  </a>
										</div>
										
										<div class="col-4 my-3 text-center">
											<a href="pin-change.php" class="nav-link info-tab-item" title=" পিন পরিবর্তন"><i class="profile-icon fa-duotone fa-solid fa-key fa-2x"></i> <br>  পিন পরিবর্তন </a>
										</div>
										
										<div class="col-4 my-3 text-center">
											<a href="password-change.php" class="nav-link info-tab-item" title="পাসওয়ার্ড পরিবর্তন"><i class="profile-icon fa-solid fa-lock-hashtag fa-2x"></i> <br>  পাসওয়ার্ড পরিবর্তন </a>
										</div>
										
										
									</div>
									
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
		

		
    </main>

    
</body>
</html>
